// Copyright 1994 by Jon Dart.  All Rights Reserved.

#ifndef _RMOVE_H
#define _RMOVE_H

#include "emove.h"

class ReversibleMove : public ExtendedMove
{
	// a move that can be "undone"
	public:
		
        ReversibleMove();		
		
        ReversibleMove( const Board &ABoard, const Square start,
			const Square dest, 
		        const Piece::PieceType promotion = Piece::Invalid);
				
	ReversibleMove( const Board &ABoard, const ExtendedMove &emove);
	
	~ReversibleMove()
	{
	}
	
	hash_t Old_HashCode() const
	{
	   return old_hashcode;
	}
	
	Board::CastleType Old_CastleStatus( const ColorType side) const
	{
	   return old_castlestatus[side];
	}
	
	const Square &Old_EnPassantSq( const ColorType side ) const
	{
	    return old_enpassantsq[side];
	}
	
	private:
		
	hash_t old_hashcode;
	Board::CastleType old_castlestatus[2];
	Square old_enpassantsq[2];
};

#endif

